# HealthySkin Co. Brand Voice Guide

## Voice summary

HealthySkin Co. sounds like a knowledgeable friend who is genuinely enthusiastic about skincare science but never lectures. The voice is warm and direct, grounded in ingredient specifics rather than vague promises, and treats the reader as someone who cares about what goes on their skin and why. There is a quiet confidence — claims are specific and backed by formulation details, not superlatives.

## Voice calibration

The user was presented with three variations of a product description for a brightening eye cream:

**A:** "Our Luminous Eye Complex brings together niacinamide and caffeine to gently wake up tired under-eyes. Think of it as your morning coffee, but for your skin — minus the jitters. Lightweight, absorbs in seconds, plays beautifully under concealer."

**B:** "Formulated with 5% niacinamide and encapsulated caffeine, the Luminous Eye Complex targets dark circles and puffiness through two complementary pathways. The fast-absorbing gel texture layers seamlessly under makeup without pilling."

**C:** "Dark circles? Meet your match. The Luminous Eye Complex pairs niacinamide with caffeine to brighten and de-puff — no heavy creams, no waiting around. Just smooth it on and get on with your morning."

**User selected: A** — noting they liked the ingredient specificity of B but preferred the personality and warmth of A. Found C too aggressive and salesy.

## Tone spectrums

| Spectrum | Position | Evidence |
|----------|----------|----------|
| Formal ↔ Casual | Casual but informed — contractions are standard, sentence fragments appear occasionally, but ingredient names and concentrations are always precise | "Think of hyaluronic acid as your skin's favorite drink" alongside "0.5% retinol encapsulated in squalane for slow release" |
| Serious ↔ Playful | Playful with substance — humor is light and analogy-driven, never at the expense of credibility | "Your moisture barrier called. It wants backup." followed immediately by specific formulation details |
| Technical ↔ Accessible | Accessible-first with technical depth available — leads with the benefit, follows with the science | "Calms redness on contact (that's the centella)" rather than "Centella asiatica extract provides anti-inflammatory properties" |
| Reserved ↔ Enthusiastic | Genuinely enthusiastic but never breathless — excitement is directed at ingredient science and results, not at the product itself | "We spent eleven months getting this texture right" rather than "You'll LOVE this amazing new formula!" |
| Authoritative ↔ Conversational | Conversational with earned authority — speaks as someone who has done the research and is sharing findings with a friend | "Here's what we know about bakuchiol" rather than "Studies have demonstrated that bakuchiol..." |
| Minimal ↔ Expressive | Moderately expressive — uses analogies and sensory language but paragraphs stay tight, typically 2-3 sentences | Product descriptions average 60-80 words; email paragraphs rarely exceed 3 sentences |

## Vocabulary

### Words and phrases to use

**Descriptive:** lightweight, silky, bouncy, dewy, plump, melty (texture words that are sensory and specific); clean-rinsing, fast-absorbing, non-greasy (functional descriptors)

**Action verbs:** smooth on, layer, pat in, boost, calm, drench, wake up, reset — tactile verbs that describe what the user physically does or what the product physically does to skin

**Connectors:** "here's the thing," "think of it as," "translation:," "in plain English" — phrases that bridge technical content to accessible explanation

**Calls-to-action:** "try it with," "pair it with," "your skin will thank you" — soft, suggestion-oriented rather than imperative

### Words and phrases to avoid

- **"Anti-aging"** — absent across all samples despite being a skincare standard. The brand discusses specific concerns (fine lines, firmness, elasticity) rather than using the umbrella term.
- **"Luxurious" / "luxury"** — never appears. Price positioning is implicit through ingredient quality, not through lifestyle signaling.
- **"Miracle" / "magic" / "transform"** — the brand avoids overclaiming. Results language is specific: "reduces redness in two weeks" rather than "transforms your skin."
- **"Clean beauty"** — despite formulating without common irritants, the brand avoids the "clean" label and instead lists what is and is not in the formula.
- **"Buy now" / "Shop now"** — CTAs in the samples use softer language: "find your routine," "see the full ingredient list," "try it for yourself."

### Jargon handling

Technical ingredient names are used (niacinamide, squalane, centella asiatica) but always paired with a plain-language explanation on first mention. Concentrations and percentages appear frequently and are treated as trust signals rather than jargon. The brand assumes the reader is interested in ingredients but does not assume prior knowledge.

Pattern: "[ingredient name] — [what it does in plain language]" appears in 7 of 8 product descriptions.

## Sentence style

### Structure patterns

Sentences are short to medium (8-18 words typical). The brand uses a rhythm of one longer explanatory sentence followed by a short punchy one: "We paired niacinamide with zinc PCA to balance oil production without stripping your skin. No tightness. No flaking."

Sentence fragments are used deliberately for emphasis and rhythm, never for laziness: "Lightweight. Breathable. Gone in ten seconds."

Paragraphs in product descriptions are 2-3 sentences. Email paragraphs occasionally extend to 4 sentences but never longer.

Opening pattern: product descriptions consistently lead with what the product does for the user (benefit-first), then follow with how it works (ingredient/mechanism). Never leads with the product name or a feature.

### Person and address

Second person ("you," "your skin") is dominant — used in 9 of 10 samples. First person plural ("we") appears when discussing formulation decisions: "We chose encapsulated retinol because..." The customer is addressed as a peer who is curious and capable of understanding the science, not as someone who needs to be told what to do.

## Formatting conventions

- **Exclamation marks:** Rare. Approximately one per product page, never more than one per paragraph. Used for genuine enthusiasm ("Eleven months of testing!"), never for hype.
- **Em dashes:** Frequent. Used to insert ingredient explanations: "centella asiatica — the same plant used in traditional wound healing."
- **Parenthetical asides:** Occasional, conversational: "(yes, even on oily skin)" or "(your morning coffee, but for your face)."
- **Capitalization:** Sentence case everywhere. Product names use title case. Never all-caps for emphasis.
- **Lists vs. paragraphs:** Ingredient lists use bullets. Everything else is flowing paragraphs. Bullet points are functional, not stylistic.
- **Emoji:** Absent from product pages and emails. Occasional in social captions (plant and droplet emojis only — no faces, no fire, no stars).

## Rhetorical patterns

**Benefit claims** are grounded in formulation specifics: "5% niacinamide to even your tone over 4-6 weeks" rather than "brightens your complexion." Results are time-bound and hedged appropriately.

**Trust-building** operates through transparency about formulation decisions: "We tried three different vitamin C derivatives before settling on ascorbyl glucoside — it's more stable, even if it's less flashy on a label." The brand earns authority by showing its work.

**Analogy and metaphor** are the primary tools for making science accessible: "Think of your moisture barrier as a brick wall — ceramides are the mortar." Analogies reference everyday objects, not luxury or aspirational imagery.

**Urgency and scarcity** are absent. No limited-time language, no countdown pressure, no "selling fast" signals in any sample.

**Social proof** is light — a mention of "thousands of routines" in one email but no review counts, celebrity endorsements, or award badges in the product copy itself.

## Demonstration rewrites

**Content type:** Product description

**BEFORE (generic):**
Discover our amazing new hydrating serum. This luxurious formula is packed with powerful ingredients to transform your skin. Get ready for a radiant, youthful complexion. Shop now and see the difference!

**AFTER (brand voice):**
A hydrating serum that actually feels like water — not another heavy layer. We combined three molecular weights of hyaluronic acid with squalane so hydration reaches deeper than the surface and stays there. Smooth it on after cleansing, before everything else. Your skin drinks it in about fifteen seconds.

**WHY:**
Leads with sensory benefit and texture, not with excitement (Tone Spectrums > Serious ↔ Playful). Uses specific ingredient details with plain-language explanation (Vocabulary > Jargon Handling). Avoids "luxurious," "transform," "amazing," and "Shop now" (Vocabulary > Words to Avoid). Addresses the reader in second person as a peer (Sentence Style > Person and Address). CTA is a soft usage instruction, not a purchase command (Vocabulary > Calls-to-Action). Short sentences with a fragment for rhythm (Sentence Style > Structure Patterns).

---

**Content type:** Email subject line

**BEFORE (generic):**
Don't miss out! Our biggest sale of the year starts NOW

**AFTER (brand voice):**
The serum we spent eleven months on is finally here

**WHY:**
No urgency language, no all-caps, no exclamation marks (Formatting Conventions; Vocabulary > Words to Avoid). Builds intrigue through the formulation story rather than a discount (Rhetorical Patterns > Trust-Building). Single sentence, no punctuation pressure (Sentence Style > Structure Patterns).

---

**Content type:** Social caption

**BEFORE (generic):**
Our NEW moisturizer is a total game-changer! Packed with the BEST ingredients for glowing, healthy skin. Link in bio to shop!

**AFTER (brand voice):**
Ceramides, squalane, and oat extract — three ingredients your moisture barrier actually recognizes. Our new daily moisturizer is the simplest step in your routine and the one your skin notices most. Full ingredient list on the product page.

**WHY:**
Opens with specific ingredients using the em-dash explanation pattern (Formatting Conventions; Vocabulary > Jargon Handling). No all-caps, no "game-changer" superlatives (Vocabulary > Words to Avoid). CTA points to information, not to a purchase (Vocabulary > Calls-to-Action). Addresses skin in the second person with the body-as-agent pattern — "your skin notices" (Sentence Style > Person and Address). No emoji in this context despite being social (Formatting Conventions > Emoji — this brand uses them sparingly even on social).

## How to use this guide

Save this document and keep it accessible. When using AI skills for content generation — product descriptions, emails, landing pages, social captions — upload or paste this guide alongside your request. Provide the full guide rather than excerpting individual sections. The voice is the combination of all these patterns working together, not any single dimension in isolation.

When reviewing AI-generated content, use the Tone Spectrums table and Vocabulary lists as a checklist: does the output match the documented positions and use the right words? The Demonstration Rewrites show what the voice looks like in practice across different content types.
